package com.rocogz.merchant.entity.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:状态操作记录 </dd>
 * <dd>@date: 2023/07/21</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoodsOperationRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String  goodsCode;

    /**
     * 操作项
     */
    private String operationItem;

    /**
     * 操作前状态
     */
    private String beforeOperationStatus;

    /**
     * 操作后状态
     */
    private String afterOperationStatus;

    /**
     * 操作人用户名
     */
    private String operator;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作时间
     */
    private LocalDateTime operationTime;

    /**
     * 日志内容
     */
    private String logContent;

}