package com.rocogz.merchant.request.customer.goods;

import com.rocogz.merchant.enumerate.ProductSortField;
import com.rocogz.merchant.pager.Sort;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * B端代理人 搜索产品 请求参数
 * @author zhangmin
 * @date 2021/2/3
 */
@Data
@Accessors(chain = true)
public class BAgentSearchGoodsReq {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     * 两个含义：
     * 1.如果主体是原来的指定产品配置，则这个是主体所属的customerCode
     * 2.如果主体产品模式是产品池，则指的是使用哪个客户产品
     */
    private String customerCode;

    /**
     * 产品编号 客户产品
     */
    private String goodsCode;


    /**
     * Y/N 主要是B的产品详情也用了列表的查询
     * 这个标记就是查出的产品再查询下其他信息
     */
    private String loadPlatformRelInfo;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 产品状态
     */
    private String status;

    /**
     * 产品类型 对应merchant_goods.good_type_code
     */
    private String goodsType;

    /**
     * 产品类型 对应merchant_goods.good_type
     */
    private List<String> goodsTypeCodeList;

    /**
     * 产品类型 列表 需求：如果商品类型下没有商品就不返回，用这个传递一个集合过来.
     */
    private List<String> goodsTypeList;

    private BigDecimal minCostPrice;

    private BigDecimal maxCostPrice;

    private BigDecimal minMarketPrice;

    private BigDecimal maxMarketPrice;

    private ProductSortField sortProperty = ProductSortField.DEFAULT;

    private Sort.Direction direction = Sort.Direction.ASC;

    /**
     * 页大小
     */
    private Integer limit=10 ;

    /**
     * 当前页
     */
    private Integer page=1 ;
}
