package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.merchant.constant.StarChargeConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import static com.rocogz.merchant.constant.StarChargeConstant.STAR_CHARGE_COUPON_TYPE.*;

/**
 * 星星充电-卡券信息
 */
@Data
@Accessors(chain = true)
public class StarChargeCoupon {

    /**
     * 额度值
     */
    @JsonProperty(value = "Amount")
    private BigDecimal Amount;

    /**
     * 剩余额度值
     */
    @JsonProperty(value = "SurplusAmount")
    private BigDecimal SurplusAmount;

    /**
     * 有效开始时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "StartTime")
    private LocalDateTime StartTime;

    /**
     * 有效结束时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "EndTime")
    private LocalDateTime EndTime;

    /**
     * 手机号
     */
    @JsonProperty(value = "PhoneNumber")
    private String PhoneNumber;

    /**
     * 卡券code
     */
    @JsonProperty(value = "Code")
    private String Code;

    /**
     * 状态
     * @see StarChargeConstant.STAR_CHARGE_COUPON_TYPE
     */
    @JsonProperty(value = "Status")
    private String Status;

    /**
     * 是否是部分使用
     */
    public boolean hasPartUsed(){
        //如果剩余金额小于总金额，且大于0，说明是部分使用了
        if(SurplusAmount != null && Amount != null){
            return SurplusAmount.compareTo(BigDecimal.ZERO) > 0 && SurplusAmount.compareTo(Amount) < 0;
        }
        return false;
    }

    /**
     * 是否已经有使用过
     */
    public boolean hasUsed(){
        boolean used = USED.equals(Status);
        if(used){
            return true;
        }
        //如果是部分使用，也算使用过了
        return this.hasPartUsed();
    }

}
