package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 星星充电请求参数Dto（包括查询券和撤回滴滴券）</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2023-04-24 15:28:59</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Setter @Getter
@Accessors(chain = true)
public class StarChargeQueryCouponRespDto {

    /**
     * 上游订单编号
     */
    private String orderItemCode;

    /**
     * roco用户券编码
     */
    private String userCouponCode;

    /**
     * 上游订单的使用状态，如果是已使用那就不用更新了
     */
    private String useStatus;

    /**
     * 星星充电优惠券信息
     */
    private StarChargeCoupon coupon;

}
