package com.rocogz.merchant.dto.goods;

import com.rocogz.merchant.entity.product.MerchantProductCatalog;
import lombok.Getter;
import lombok.Setter;

/**
 * 选择 产品分类关联客户产品查询参数
 *
 * @author zhangmin
 */
@Setter
@Getter
public class ChooseCatalogCustomerProductParamDto {

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 分类编号，已加入的分类客户产品，要排除掉
     *
     * @see MerchantProductCatalog#code
     */
    private String catalogCode;

    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称【模糊匹配】
     */
    private String customerProductName;

    /**
     * 产品类别
     *
     * @see com.rocogz.merchant.entity.goods.MerchantGoods#goodsType
     */
    private String productType;

    /**
     * 客户产品上下架状态
     */
    private String customerProductStatus;

    /**
     * 页大小
     */
    private Integer limit = 10;

    /**
     * 当前页
     */
    private Integer page = 1;


}
