package com.rocogz.merchant.dto.goods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.product.MerchantCustomerGoodsCatalog;
import com.rocogz.merchant.entity.product.MerchantProductCatalog;
import com.rocogz.merchant.entity.storeservice.MerchantStoreServicePrice;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 商户中心- 产品分类关联的客户产品信息vo
 * </p>
 *
 * @author zhangmin
 * @since 2023-08-15
 */
@Data
@Accessors(chain = true)
public class MerchantCatalogBoundCustomerProductVo {

    /**
     * 关联关系Id
     *
     * @see MerchantCustomerGoodsCatalog#id
     */
    private Integer boundId;

    /**
     * 产品分类编号
     *
     * @see MerchantProductCatalog#code
     */
    private String catalogCode;


    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     *
     * @see MerchantCustomerGoods#name
     */
    private String customerProductName;

    /**
     * 客户产品上下架状态
     *
     * @see MerchantCustomerGoods#status
     */
    private String customerProductStatus;


    /**
     * 客户产品的 市场价/面额
     *
     * @see MerchantCustomerGoods#marketPrice
     */
    private BigDecimal customerProductMarketPrice;

    /**
     * 客户产品的 额度扣减单价
     *
     * @see MerchantCustomerGoods#settlePrice
     */
    private BigDecimal customerProductSettlePrice;


    /**
     * 服务项目成本价
     *
     * @see MerchantStoreServicePrice#settlePrice
     */
    private BigDecimal costPrice;

    /**
     * 平台产品编号
     *
     * @see MerchantGoods#code
     */
    private String productCode;


    /**
     * 客户产品类型,自营/平台
     *
     * @see MerchantCustomerGoods#customerGoodsType
     */
    private String customerGoodsType;

    /**
     * 供应商产品编号,自营服务项目 构建服务项目成本价会使用该字段
     *
     * @see MerchantGoods#supplierGoodsCode
     */
    private String supplierProductCode;

    /**
     * 产品类别
     *
     * @see MerchantGoods#goodsType
     */
    private String productType;


    /**
     * 产品类别名称
     *
     * @see MerchantGoods#goodsType
     */
    private String productTypeName;


    /**
     * 是否是自营服务项目
     */
    @JsonIgnore
    public boolean isHaveServiceProject() {
        return Constant.General.MERCHANT_CUSTOMER_GOODS_HAVE.equalsIgnoreCase(customerGoodsType)
                && Constant.DictData.PRODUCT_TYPE_SERVICE.equalsIgnoreCase(productType);
    }

}
