package com.rocogz.merchant.dto.issuingBody.customerGoods;

import com.rocogz.merchant.enumerate.GoodsTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description:主体产品查询是个综合查询 </dd>
 * <dd>@date: 2023/07/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyGoodsDto {

    /**
     * 合作客户产品ID，这个是admin跳转详情的是否会用到
     */
    private Integer id;

    /**
     * 合作客户产品编号 为了兼容一些弹窗 code 也存储下客户产品编号
     */
    private String code;

    /**
     * 合作客户产品编码
     */
    private String customerGoodsCode;

    /**
     * 合作客户产品名称 为了兼容一些弹窗 name 合作客户产品名称
     */
    private String name;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;


    /**
     * 合作客户产品名称
     */
    private String customerGoodsName;

    /**
     * 客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 客户产品： 额度扣减单价
     *
     * merchant_customer_goods.settle_price
     */
    private BigDecimal customerGoodsSettlePrice;

    /**
     * 客户产品： 采购结算单价
     *
     *  merchant_customer_goods.purchase_settle_price
     */
    private BigDecimal customerGoodsPurchaseSettlePrice;

    /**
     * 客户产品：市场价
     *
     * merchant_customer_goods.market_price
     */
    private BigDecimal customerGoodsMarketPrice;

    /**
     * 客户产品类型
     * @see Constant.General#MERCHANT_CUSTOMER_GOODS_merchant 平台
     *
     * @see Constant.General#MERCHANT_CUSTOMER_GOODS_HAVE 自有
     *
     * merchant_customer_goods.customer_goods_type
     */
    private String customerGoodsType;

    /**
     * 是否启用备付金
     * merchant_customer_goods.need_provisions
     */
    private String needProvisions;

    /**
     * 服务商编号
     */
    private String agentCode;

    /**
     * 服务商产品编号
     */
    private String agentGoodsCode;

    /**
     * 服务商产品名称
     */
    private String agentGoodsName;

    /**
     * 代理商产品状态
     */
    private String agentGoodsStatus;

    /**
     * 平台产品编号
     */
    private String merchantGoodsCode;

    /**
     * 平台产品名称
     */
    private String merchantGoodsName;

    /**
     * 平台产品状态
     */
    private String merchantGoodsStatus;

    /**
     * 成本价 也就是：平台采购价
     * merchant_goods.cost_price
     */
    private BigDecimal merchantGoodsCostPrice;

    /**
     * 平台产品 市场价/面额
     * merchant_goods.market_Price
     */
    private BigDecimal merchantGoodsMarketPrice;


    /***
     * 服务券 产品类别是SERVICE的,通过平台产品上的supplier_goods_code,
     *
     * 成本价，如果没有返回的是null
     *
     * 查询merchant_store_service_price 服务项目中的成本价 merchant_store_service_price.settle_price
     */
    private BigDecimal serviceCostPrice;

    /**
     * 产品类别(本来这个是产品类型,后来牛哥说把这个改为产品类别,新加了一个产品类型,在下面用GoodsTypeCode表示)
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     *
     * merchant_goods.goods_type
     */
    private String goodsType;

    /**
     * 产品内容 merchant.goods_content
     */
    private String goodsContent;

    /**
     *  产品类型code
     *  merchant_goods.goods_type_code
     *
     *  从 Merchant_product_type 中取
     */
    private String  goodsTypeCode;

    /**
     * 产品类型code对应的名字
     */
    private String goodsTypeCodeName;

    /**
     * 品牌编码
     * merchant_goods.brand_code
     */
    private String brandCode;

    /**
     * 使用有效期-结束日期(天)
     * merchant_goods.use_validity
     * 平台产品上的
     */
    private Integer merchantGoodsUseValidity;

    /**
     * 是否虚拟商品(Y:是,N:否)
     * merchant_goods.invented
     */
    private String invented;

    /**
     * 是否需要发券(Y:是,N:否)
     * merchant_goods.whether_need_issue_coupon
     */
    private String whetherNeedIssueCoupon;

    /**
     * 产品类型,这个需要说明下
     * @see GoodsTypeEnum 这个是原来单客户弹窗返回的使用了 goodsNature,
     * 但其实这个goodsNature是平台产品中的一个字段，含义是 单品，自定义套餐，供应商套餐 标记
     *
     * 所以为了兼容 goodsNature还是按单客户弹窗逻辑处理
     *
     * 同时也会返回 merchantGoodsNature 表示平台产品中的goods_nature
     */
    private String goodsNature;

    /**
     * 产品性质
     *
     * Constant.DictData#GOODS_NATURE_ITEM
     *
     * merchant_goods.goods_nature
     */
    private String merchantGoodsNature;


    /**
     * 供应商产品编号，服务项目的编号会填写到这个里面
     *
     * 返回返查 merchant_store_service_price 这个里面的价格
     *
     * merchant_goods.supplier_goods_code
     */
    private String supplierGoodsCode;


    /**
     * 是否启用库存
     * merchant_goods.whether_need_stock
     */
    private String whetherNeedStock;

    /**
     * 供应商
     * merchant_goods.supplier_code
     */
    private String supplierCode;

    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 可售库存
     */
    private Integer sellableStock;


    /**
     * 主体产品状态 只有主体模式是CUS_PRO_ITEM 这个才有值
     */
    private String issuingBodyGoodsStatus;

    /**
     * 产品的一个综合状态：
     * 1.当主体是指定产品模式时 只有 主体产品状态 和 合作客户产品状态 都是UP_LIST 才是 UP_LIST
     * 2.当主体是产品池模式时 合作客户产品状态 UP_LIST 才是UP_LIST
     */
    private String status;


    /**
     * 客户产品所属产品库类型
     * 这个适用在产品库模式中返回，
     */
    private String proWhBelongType;


    /***
     *  这个适用在产品库模式中返回，
     */
    private String proWhBelongName;


     /**
     * 小程序显示名称
      * 合作客户 merchant_customer_goods.applet_display_name
     */
    private String appletDisplayName;


    /**
     * product_goods.list_view
     */
    private String listView;





}

