package com.rocogz.merchant.dto.issuingBody.goodsConfigPool;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 场景：
 * 1.前端 传递一个 当前用户的费用 类型 返回B端首页的仓库
 * </dd>
 * <dd>@date: 2023/07/10</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyGoodsConfigResp {

    /**
     * 1.CUS_PRO_ITEM : 发放主体可发放产品 merchant_issuing_body_customer_goods
     * 2.CUS_POOL  : 产品池配置
     *
     * 只有当是CUS_PRO_ITEM :存储在  merchant_issuing_goods_pool_config
     */
    private String goodsConfigModel;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 主体关联的合作客户编号
     */
    private String issuingBodyCustomerCode;

    /***
     * 产品池配置项
     */
    private List<GoodsPoolConfigItem>  goodsPoolsConfigList;


    @Getter
    @Setter
    public static class GoodsPoolConfigItem{

        /**
         * 商品来自哪个合作客户
         */
        private String goodsFromCustomerCode;

        /**
         * 产品库名称
         */
        private String proWhBelongName;

        /**
         * 产品库类型 T_WH总行库，SUB_WH分行库
         */
        private String proWhBelongType;

        /**
         * true  为总行仓
         * false 为分行仓
         */
        private Boolean tWhTag;

        /**
         * 主体额度账户费用类型 ALL/SPECIAL_USE/UNIVERSAL_USE
         */
        private String acctFeeType;

    }


}
