package com.rocogz.merchant.dto.issuingBody.goodsConfigPool;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * <dl>
 * <dd>Description:保存的项目 </dd>
 * <dd>@date: 2023/07/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MerchantIssuingBodyGoodsPoolConfigSaveItemDto {

    /**
     * 配置项编号
     */
    private String code;

    /**
     * 合作客户Code 这个合作客户产品不一定是主体所对应的
     * 是选择出来的
     */
    @NotBlank(message = "请传递客户编号")
    private String customerCode;

    /**
     * 产品库类型 T_WH总行库，SUB_WH分行库
     *
     * 一个主体最多只能配置一个类型
     * @see Constant.IssuingBodyGoodsPoolWarehouseBelongType#TYPE_CODE
     */
    @NotBlank(message = "请传递产品库类型")
    private String proWhBelongType;

    /**
     * 产品库名称
     */
    @NotBlank(message = "请传递产品库名称")
    private String proWhBelongName;

    /**
     * 主体额度账户费用类型 ALL/SPECIAL_USE/UNIVERSAL_USE
     *
     * @see Constant.IssuingBodyGoodsPoolWarehouseFeelType#TYPE_CODE
     */
    @NotBlank(message = "请传递产品库费用类型")
    private String acctFeeType;

    /**
     * 商品的 出库仓库编号 是MerchantScmWarehouse这里面的
     * 默认从平台仓库出库，不传递默认设置为平台库
     */
    private String outWhType;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;

    /**
     * 产品库类型字典名称
     */
    private String proWhBelongTypeDictName;

}
