package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.entity.scm.MerchantScmOilCardOrderDetailInfo;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 分销明细订单更新实体类
 * @author djt
 * @date 2021/3/10
 */
@Data
public class ScmOrderDetailUpdateDTO {
    /**
     * 明细订单
     */
    @NotNull
    private MerchantScmOrderDetail merchantScmOrderDetail;

    /**
     * 直充电子油卡券信息
     */
    private MerchantScmOilCardOrderDetailInfo merchantScmOilCardOrderDetailInfo;

    public ScmOrderDetailUpdateDTO() {
    }

    public ScmOrderDetailUpdateDTO(@NotNull MerchantScmOrderDetail merchantScmOrderDetail) {
        this.merchantScmOrderDetail = merchantScmOrderDetail;
    }

    public ScmOrderDetailUpdateDTO(@NotNull MerchantScmOrderDetail merchantScmOrderDetail, MerchantScmOilCardOrderDetailInfo merchantScmOilCardOrderDetailInfo) {
        this.merchantScmOrderDetail = merchantScmOrderDetail;
        this.merchantScmOilCardOrderDetailInfo = merchantScmOilCardOrderDetailInfo;
    }
}
