package com.rocogz.merchant.dto.scm.electric;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 电卡金额dto
 * @author zhangmin
 */
@Setter @Getter
public class ElectricScmOrderAmtDto {

    /**
     * 下游订单号
     */
    private String scmOrderCode;


    /**
     * 下游订单，对应的电卡要充值金额，即要写入电卡账户中，增加的电量 （使用平台产品市场价/发放面额计算）
     */
    private BigDecimal totalChargeAmt;


    /**
     * 下游订单：总的采购价格，即要扣减南网的钱
     */
    private BigDecimal totalPurchasePrice;


}
