package com.rocogz.merchant.dto.scm.electric;

import com.rocogz.merchant.entity.channel.product.MerchantChannelProduct;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

/**
 * @author zhangmin
 */
@Setter @Getter
@NoArgsConstructor
@Accessors(chain = true)
public class ElectricValidateResultDto {

    /**
     * 下游订单，电卡充值总金额,用发放面额/平台产品市场价计算的
     */
    private BigDecimal totalChargeAmt;

    /**
     * 单个 电卡充值金额,  即单个 发放面额/平台产品市场价
     */
    private BigDecimal singleChargeAmt;

    /**
     * 下游订单，要扣减的南网电卡总金额，使用 平台产品采购价计算
     */
    private BigDecimal totalDeductNwAmt;

    /**
     * 单个 扣减的南网电卡总金额，使用 平台产品采购价计算
     * （1) //非固定面额的 电卡产品 采购单价 = 平台产品的采购价 * unitFaceValue / 平台产品的市场价
     *     singleElectricPurchaseAmt = scmProduct.getPurchasePrice().multiply(scmSendDto.getUnitFaceValue()).divide(scmProduct.getMarketPrice())
     *
     *   //固定面额电卡
     *  (2) singleElectricPurchaseAmt = scmProduct.getPurchasePrice()
     */
    private BigDecimal singleElectricPurchaseAmt;

    /**
     * 通道产品
     */
    private MerchantChannelProduct channelProduct;

    /**
     * 配置的 平台产品采购价 是否等于 平台产品市场价，即 采购价与市场价 是否是1:1
     */
    private Boolean purchaseIsEqMarketPrice;
}
