package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.channel.product.MerchantChannelProduct;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 撤回下游订单中，包括的星星充电电卡上游订单
 * @author zhangmin
 */
@Setter @Getter
@NoArgsConstructor
public class RecallStarElectricScmOrderItem {

   /**
    * 上游订单号
    * @see MerchantScmOrderDetail#orderItemCode
    */
   private String scmOrderItemCode;


   private String orderItemStatus;

   /**
    * 使用状态
    * @see Constant.DictUseStatus
    * @see MerchantScmOrderDetail#useStatus
    */
   private String useStatus;

   /**
    * roco用户券
    * @see MerchantScmOrderDetail#rocoUserCouponCode
    */
   private String rocoUserCouponCode;

   /**
    * @see MerchantScmOrderDetail#thirdBusinessCode
    */
   private String thirdBusinessCode;

   /**
    * 产品类别,上游订单中的产品类型,该产品类型用来决定走不同的上游订单Handler处理器类，非常重要
    * (1) 如果是不是平台自定义套餐,productType = MerchantScmProductInformation#productType
    * (2) 如果是平台自定义套餐，则 productType = 自定义平台套餐中子产品的产品类型
    *
    * @see Constant.DictData#PRODUCT_TYPE_FIXED_ELECTRIC
    */
   private String productType;

   /**
    * 结算扣款主体编号
    * @see MerchantScmOrderDetail#channelProductDeductSubjectCode
    */
   private String deductSubjectCode;

   /**
    * 通道产品上第三方产品编号
    * @see MerchantChannelProduct#thirdProductCode
    */
   private String thirdProductCode;


   public static RecallStarElectricScmOrderItem of(MerchantScmOrderDetail detail) {
      RecallStarElectricScmOrderItem item = new RecallStarElectricScmOrderItem();
      item.setScmOrderItemCode(detail.getOrderItemCode());
      item.setOrderItemStatus(detail.getOrderStatus());
      item.setUseStatus(detail.getUseStatus());
      item.setProductType(detail.getProductType());
      item.setThirdBusinessCode(detail.getThirdBusinessCode());
      item.setRocoUserCouponCode(detail.getRocoUserCouponCode());
      item.setDeductSubjectCode(detail.getChannelProductDeductSubjectCode());
      return item;
   }

}
