package com.rocogz.merchant.dto.supplierGoods;

import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:权益产品库产品列表 </dd>
 * <dd>@date: 2023/07/21</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class SupplierEquityGoodsListDto {
    /**
     * 机构编码
     */
    private String customerCode;

    /**
     * 客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 机构简称
     */
    private String customerAbbreviation;

    /**
     * 合作客户产品编码
     */
    private String customerGoodsCode;

    /**
     * 列表图 平台产品的
     */
    private String listView;

    /**
     * 产品名称
     */
    private String customerGoodsName;

    /**
     * 平台产品简称
     */
    private String platformGoodsAbbreviation;

    /**
     * ERP产品编号
     * merchant_goods.erp_goods_code
     */
    private String erpGoodsCode;

    /**
     * 品牌编号
     */
    private String brandCode;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 类型编码
     */
    private String goodsTypeCode;

    /**
     * 产品类型编码名称
     */
    private String goodsTypeCodeName;

    /**
     * 客户产品市场价
     */
    private BigDecimal customerGoodsMarketPrice;

    /**
     * 客户产品采购结算价格
     */
    private BigDecimal customerGoodsPurchaseSettlePrice;

    /**
     * 供应商编号
     */
    private String supplierCode;

    /**
     * 供应商
     */
    private String supplierName;

    /**
     * 供应商产品编码 平台产品编码
     */
    private String platformGoodsCode;

    /**
     * 客户产品创建时间
     */
    private LocalDateTime customerGoodsCreateTime;

    //详情中要用的
    /**
     * 产品型号
     * merchant_goods.model
     */
    private String model;

    /**
     * 是否虚拟商品(Y:是,N:否)
     *
     * merchant_goods.invented
     */
    private String invented;

    /**
     * 产品亮点
     * merchant_goods.sale_light_point
     */
    private String saleLightPoint;

    /**
     * 产品内容
     * merchant_goods.goods_content
     *
     */
    private String goodsContent;

    /**
     * 列表图
     */
    private List<MerchantAttechment> detailImages;


    /**
     * 产品详情
     * merchant_goods.introduce
     */
    private String  introduce;

    /**
     * 产品参数
     * merchant_goods.goodsParameters
     */
    private String  goodsParameters;

    /**
     * 入库申请单号
     */
    private String inApplyCode;

    /**
     * 虚拟产品兑换使用地址
     */
    private String exchangeUseAddress;

}
