package com.rocogz.merchant.entity.combo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 套餐详情
 * </p>
 *
 * @author yifenrui
 * @since 2020-12-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_combo_detail")
public class MerchantComboDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 套餐编码
     */
    private String comboCode;

    /**
     * 关联编码：服务项目、优惠券等
     */
    private String relateCode;

    /**
     * 关联对象类型：服务项目、优惠券等
     */
    private String relateType;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    private Integer count;

    /**
     * 排序
     */
    private Integer sort;


    /**
     * 商户服务项目名称
     */
    @TableField(exist = false)
    private String packageName;


    /**
     * 服务所属分类编码
     */
    @TableField(exist = false)
    private String cataCode;

    /**
     * 服务所属分类名称
     */
    @TableField(exist = false)
    private String cataName;


    /**
     * 服务状态
     */
    @TableField(exist = false)
    private String serviceStatus;

    /**
     * 项目数量
     */
    @TableField(exist = false)
    private Integer projectNum;


    /**
     * 服务图片
     */
    @TableField(exist = false)
    private String  imageUrl;






}
