package com.rocogz.merchant.entity.combo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 套餐操作日志
 * </p>
 *
 * @author yifenrui
 * @since 2020-12-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_combo_log")
public class MerchantComboLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 关联操作对象编码
     */
    private String code;

    /**
     * 操作类型
     */
    private String opType;

    /**
     * 操作内容
     */
    private String opContent;

    /**
     * 操作人
     */
    private String opUser;

    /**
     * 操作时间
     */
    private LocalDateTime opTime;


}
