package com.rocogz.merchant.entity.customer.workflow;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 发放主体 额度申请审批流设置,流程定义
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@TableName("merchant_customer_goods_config_node")
public class MerchantCustomerGoodsConfigNode extends BaseConfigNode {

    /**
     * 合作客户编号
     */
    private String customerCode;


    private String createUser;

    private LocalDateTime createTime;

    private String updateUser;

    private LocalDateTime updateTime;


    //该节点审批人信息
    @TableField(exist = false)
    private List<MerchantCustomerGoodsConfigNodeApprover> approverList;

}
