package com.rocogz.merchant.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 投保礼关联
 * </p>
 *
 * @author yifenrui
 * @since 2020-08-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_insurance_gift")
public class MerchantInsuranceGift extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 关联类型
     */
    private String relateType;

    /**
     * 对应的关联数据编码:商品类型时如果是全部商户则为 *
     */
    private String relateCode;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

    /**
     * 启用、停用
     */
    private String status;

    /**
     * 排序
     */
    private Integer sort;


    /**
     * 礼品名称
     */
    private String name;


    /**
     * 说明
     */
    private String introduce;

    /**
     * 礼品简称
     */
    @TableField(exist = false)
    private String simpleName;

    /**
     * 组合套餐-项目类型总数
     */
    @TableField(exist = false)
    private Integer projectTypeNum;


    /**
     * 组合套餐-项目总数
     */
    @TableField(exist = false)
    private Integer projectNum;


    /**
     * 套餐下的项目
     */
    @TableField(exist = false)
    private List<MerchantInsuranceGiftCombRelate> projectList;

    /**
     * 商品图片
     */
    @TableField(exist = false)
    private String goodsImgUrl;

    /**
     * 商品库存
     */
    @TableField(exist = false)
    private Integer goodsStock;



    /**
     * 市场价
     */
    @TableField(exist = false)
    private BigDecimal marketPriceBefore;

    /**
     * 成本价
     */
    @TableField(exist = false)
    private BigDecimal costPriceBefore;

    /**
     * 销售价
     */
    @TableField(exist = false)
    private BigDecimal settlePriceBefore;

    /**
     * 销售亮点
     */
    @TableField(exist = false)
    private String saleLightPoint;


    /**
     * 商品、代金券状态
     */
    @TableField(exist = false)
    private String giftServiceStatus;

    /**
     * 代金券使用范围
     */
    @TableField(exist = false)
    private BigDecimal useLimit;

    /**
     * 代金券使用范围
     */
    @TableField(exist = false)
    private BigDecimal useLimitMax;

    /**
     * 代金券面额
     */
    @TableField(exist = false)
    private BigDecimal faceValue;
}
