package com.rocogz.merchant.entity.issuingBody.goodsPoolConfig;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:发放主体的客户产品池信息
 * 是在浙商银行项目时引入的
 *
 *  两套配置：
 *  1.原来的MerchantIssuingBodyCustomerGoods 粒度到产品
 *  2.这个粒度只是到了客户，并且主体可以发不同客户的产品。没有强一致性要求
 *
 * </dd>
 * <dd>@date: 2023/07/08</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class MerchantIssuingBodyGoodsPoolConfig extends IdEntity {

    /**
     * 发号器生成
     */
    private String code;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 合作客户Code 这个合作客户产品不一定是主体所对应的
     * 是选择出来的
     * 但认为客户编号是不能重复的
     */
    private String customerCode;

    /**
     * 产品库类型T_WH总行库，SUB_WH分行库
     *
     * 一个主体最多只能配置一个类型
     * @see Constant.IssuingBodyGoodsPoolWarehouseBelongType#TYPE_CODE
     */
    private String proWhBelongType;

    /**
     * 产品库名称 自定义的一个名称
     */
    private String proWhBelongName;

    /**
     * 主体额度账户费用类型 ALL/SPECIAL_USE/UNIVERSAL_USE
     *
     * @see Constant.IssuingBodyGoodsPoolWarehouseFeelType#TYPE_CODE
     */
    private String acctFeeType;

    /**
     * 商品的 出库仓库编号 是MerchantScmWarehouse这里面的
     * 默认从平台仓库出库
     */
    private String outWhType;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String customerAbbreviation;

    /**
     * 产品库类型字典名称
     */
    @TableField(exist = false)
    private String proWhBelongTypeDictName;


    /**
     * 字典中的这个proWhBelongType.code 对应的sort
     */
    @TableField(exist = false)
    private Integer proWhBelongTypeSort;

}
