package com.rocogz.merchant.entity.rocomall;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * ROCO商城商品
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantRocoMallGoods extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String code;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal salePrice;

    /**
     * 排序
     */
    private Integer seq;

    /**
     * 状态
     */
    private String status;

    /**
     * 商品
     */
    @TableField(exist = false)
    private MerchantGoods merchantGoods;

    /**
     * 指定角色信息列表
     */
    @TableField(exist = false)
    private List<MerchantRocoMallGoodsSpecialPrice> appointRoleList;

    /**
     * 指定用户信息列表
     */
    @TableField(exist = false)
    private List<MerchantRocoMallGoodsSpecialPrice> appointUserList;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantRocoMallGoodsLog> logs;

    /**
     * 是否有代理人价格
     */
    @TableField(exist = false)
    private Boolean haveAgentPrice;

    /**
     * 最低指定价格
     */
    @TableField(exist = false)
    private BigDecimal minAppointPrice;

    /**
     * 可售良品库存=stock-saleStock-occupiedStock
     */
    @TableField(exist = false)
    private Integer sellableStock;
}
