package com.rocogz.merchant.entity.supplier;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 供应商产品可入库机构表
 * </p>
 * @author chenyumin
 * @since 2023-07-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_supplier_department")
public class MerchantSupplierDepartment extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 机构编码
     */
    private String code;

    /**
     * 机构名称
     */
    private String name;

    /**
     * 状态：启用(OPEN),停用(LOCK)
     * @see Constant.DictData#COMMON_STATUS_OPEN
     */
    private String status;

}
