/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.entity.channel.product.MerchantThirdPlatform;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import org.springframework.util.StringUtils;

public class RecallScmOrderItem {
    private String scmOrderItemCode;
    private String orderItemStatus;
    private String useStatus;
    private String productNature;
    private String orderType;
    private String thirdBusinessCode;
    private String productType;
    private String channelProductPlatformCode;
    private String brandCode;

    public static RecallScmOrderItem of(MerchantScmOrderDetail orderDetail) {
        if (orderDetail == null) {
            return null;
        }
        RecallScmOrderItem orderItem = new RecallScmOrderItem();
        orderItem.setOrderItemStatus(orderDetail.getOrderStatus()).setScmOrderItemCode(orderDetail.getOrderItemCode()).setProductNature(orderDetail.getGoodsNature()).setProductType(orderDetail.getProductType()).setOrderType(orderDetail.getOrderType()).setUseStatus(orderDetail.getUseStatus()).setThirdBusinessCode(orderDetail.getThirdBusinessCode()).setBrandCode(orderDetail.getBrandCode()).setChannelProductPlatformCode(orderDetail.getChannelProductPlatformCode());
        return orderItem;
    }

    public boolean isGdzsyOrderItem() {
        if (!"OIL_CARD_DIGITAL_YES".equalsIgnoreCase(this.productType) && !"OIL_CARD_DIGITAL".equalsIgnoreCase(this.productType)) {
            return false;
        }
        return "DJ_GDZSY".equalsIgnoreCase(this.channelProductPlatformCode) || StringUtils.isEmpty((Object)this.channelProductPlatformCode) && MerchantThirdPlatform.GDZSY_CHANNEL_BRANDS.contains(this.brandCode);
    }

    public RecallScmOrderItem setScmOrderItemCode(String scmOrderItemCode) {
        this.scmOrderItemCode = scmOrderItemCode;
        return this;
    }

    public RecallScmOrderItem setOrderItemStatus(String orderItemStatus) {
        this.orderItemStatus = orderItemStatus;
        return this;
    }

    public RecallScmOrderItem setUseStatus(String useStatus) {
        this.useStatus = useStatus;
        return this;
    }

    public RecallScmOrderItem setProductNature(String productNature) {
        this.productNature = productNature;
        return this;
    }

    public RecallScmOrderItem setOrderType(String orderType) {
        this.orderType = orderType;
        return this;
    }

    public RecallScmOrderItem setThirdBusinessCode(String thirdBusinessCode) {
        this.thirdBusinessCode = thirdBusinessCode;
        return this;
    }

    public RecallScmOrderItem setProductType(String productType) {
        this.productType = productType;
        return this;
    }

    public RecallScmOrderItem setChannelProductPlatformCode(String channelProductPlatformCode) {
        this.channelProductPlatformCode = channelProductPlatformCode;
        return this;
    }

    public RecallScmOrderItem setBrandCode(String brandCode) {
        this.brandCode = brandCode;
        return this;
    }

    public String getScmOrderItemCode() {
        return this.scmOrderItemCode;
    }

    public String getOrderItemStatus() {
        return this.orderItemStatus;
    }

    public String getUseStatus() {
        return this.useStatus;
    }

    public String getProductNature() {
        return this.productNature;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getThirdBusinessCode() {
        return this.thirdBusinessCode;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getChannelProductPlatformCode() {
        return this.channelProductPlatformCode;
    }

    public String getBrandCode() {
        return this.brandCode;
    }
}

