/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.dto.scm.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.dto.scm.order.ReceiptItemSettleResult;
import com.rocogz.merchant.dto.scm.order.ScmOrderSettleBaseDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ScmOrderSettleResultMsgDto
extends ScmOrderSettleBaseDto<ReceiptItemSettleResult> {
    private Boolean success;
    private String failReason;

    @JsonIgnore
    public BigDecimal getTotalBalance() {
        if (CollectionUtils.isEmpty((Collection)this.receiptItemList)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = this.receiptItemList.stream().map(ReceiptItemSettleResult::getSurplusAmount).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        return sum.setScale(3, RoundingMode.HALF_UP);
    }

    public Integer getTotalSettledOrderNum() {
        if (CollectionUtils.isEmpty((Collection)this.receiptItemList)) {
            return 0;
        }
        HashSet<String> orderCodeSet = new HashSet<String>();
        for (ReceiptItemSettleResult settleResultItem : this.receiptItemList) {
            if (CollectionUtils.isEmpty(settleResultItem.getSettledOrderList())) continue;
            for (ReceiptItemSettleResult.SettledScmOrder scmOrder : settleResultItem.getSettledOrderList()) {
                orderCodeSet.add(scmOrder.getOrderCode());
            }
        }
        int totalOrderNum = orderCodeSet.size();
        return totalOrderNum;
    }

    public ScmOrderSettleResultMsgDto setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ScmOrderSettleResultMsgDto setFailReason(String failReason) {
        this.failReason = failReason;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getFailReason() {
        return this.failReason;
    }
}

