package com.rocogz.merchant.client.scm;


import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhangmin
 */
@Setter @Getter
public class FixHistoryUpOrderValidityDto {

    private Integer orderItemId;

    private String orderCode;

    private String orderItemCode;

    private BigDecimal platProdMarketPrice;

    private BigDecimal platProdPurchasePrice;

    /**
     * 平台产品编号
     */
    private String productCode;

    private String productType;

    //单品，供应商套餐，平台自定义套餐
    private String goodsNature;

    /**
     * 合作客户产品
     */
    private String customerProductCode;

    /**
     * 服务商产品
     */
    private String agentProductCode;

    /**
     * @see MerchantScmInformation#sourceCode
     */
    private String issuingBodyCode;

    /**
     * @see com.rocogz.merchant.entity.scm.MerchantScmOrderInformation#orderType
     */
    private String orderType;

    private LocalDateTime grantTime;

    private LocalDateTime receiveTime;



    @JsonIgnoreProperties
    public String getConfigRuleProductCode() {
        if(StringUtils.isNotBlank(customerProductCode)) {
            return customerProductCode;
        }

        return agentProductCode;
    }

}
