package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Set;

/**
 * <dl>
 * <dd>Description:主体对应的合作商户发放产品的仓库 </dd>
 * <dd>@date: 2022/03/17</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingCustomerGoodsWarehouseSearchReq {

    /**
     * 主体编号
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    @NotBlank
    private String customerCode;

    /**
     * 合作客户产品编号
     */
    @NotEmpty
    private Set<String> customerGoodsCodeList;

    /**
     * 业务类型：主体中业务类型
     *
     * 主体 如果 该业务类型仅可发放已添加的专用产品：Y 再传递这个值
     */
    private String businessTypeCode;

}
