package com.rocogz.merchant.dto.goods;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author 尹世豪
 * @Description:
 * @Package com.rocogz.merchant.dto.goods
 * @date 2022/9/19 15:41
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class GoodsPageTableReqDto {
    //产品简称
    private String abbreviation;
    private String keyword;
    private String code;
    private String erpGoodsCode; //

    //页面搜索框中的ERP产品编码 其实是映射到了这个
    private String supplierGoodsCode;


    private String brandCode;

    private List<String> brandCodeList;
    //分页请求的请求Post直接用brandCodeList无法接口，先用brandCodeListStr字符串的接收然后再转成List
    private String brandCodeListStr;


    private String supplierCode;
    private String goodsClassificationCode;
    private String saleType;
    private String status;

    private List<String> supplierCodeList;
    //分页请求的请求Post直接用brandCodeList无法接口，先用brandCodeListStr字符串的接收然后再转成List
    private String supplierCodeListStr;


    private String invented;
    private String filterGoodsCodes;
    private String goodsType;
    private String mchId;
    private String goodsTypeCode;
    private String goodsTypeCodeListStr;
    private List<String> goodsTypeCodeList;
    private String goodsNature;
    private String sortField;
    private String sortType;
    private String whetherNeedStock;

    /**
     * 已知排序的属性
     * 1.adminSupplierList
     */
    private String sortProp;
    /**
     * 排除掉的产品列表
     */
    private List<String> excludeGoodsCodeList;

    //分页请求的请求Post直接用brandCodeList无法接口，先用brandCodeListStr字符串的接收然后再转成List
    private String excludeGoodsCodeListStr;

    /**
     *  Y 排除已经在入库申请中的
     */
    private String excludeHasInstoreApply;

    /**
     * 合作客户 如果传递了这个则需要 需要排除掉 商品不在 这个客户的申请单中 没有作废的
     *
     * 如果是作废了才可以再次申请 找到所有没有作废的
     */
    private String customerCode;

    private int limit;
    private int page;
}
