package com.rocogz.merchant.dto.issuingBody.goodsPool;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:发放主体产品池产品搜索 </dd>
 * <dd>@date: 2023/07/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyGoodsPoolGoodsPageReq {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 产品编号
     */
    private String customerGoodsCode;

    /**
     * 产品名称
     */
    private String customerGoodsName;

    /**
     * 产品类型 对应 merchant_goods.goods_type_code
     */
    private String goodsTypeCode;

    /**
     * 产品类别: merchant_goods.goods_type 是个字典
     */
    private String goodsType;

    /**
     * 产品库类型 T_WH 总行， SUB_WH 分行
     */
    private String proWhBelongType;

    /**
     * 客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 排序属性 proWhBelongType,customer_goods_create_time_desc
     */
    private String sortProp;

    /**
     * 每页多少
     */
    private int limit=10;

    /**
     * 当前第几页
     */
    private int page=1;

}
