package com.rocogz.merchant.dto.issuingBody.goodsPool;

import com.rocogz.merchant.dto.issuingBody.customerGoods.IssuingBodyGoodsDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description:发放主体模版中产品查询-主要是针对产品池默认是上架状态</dd>
 * <dd>@date: 2023/07/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyTemplateGoodsPoolQueryResp {

    /**
     * 发放主体
     */
    private String issuingBodyCode;

    /**
     * 发放主体的产品配置模式
     */
    private String issuingGoodsConfigModel;

    /**
     * 指定产品池模式
     */
    private Map<String, List<IssuingBodyGoodsDto>> goodsPoolMap;

    /**
     * 指定产品模式
     */
    private List<IssuingBodyGoodsDto> goodsItemList;

}
