package com.rocogz.merchant.dto.storeservice.issuingBody;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:菜单：发放主体发放项目管理
 * 查询的是已主体已配置的产品合作客户产品
 *
 * 合作客户产品 关联 平台产品 关联 商户服务项目 找到服务项目
 * </dd>
 * <dd>@date: 2022/12/02</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyStoreServiceGoodsPageReq {

    //发放主体编号
    private List<String> issuingBodyCodeList;

    //合作客户编号
    private List<String> customerCodeList;

    /**
     * 商户服务项目编码
     */
    private String serviceCode;

    /**
     * 商户服务项目名称
     */
    private String serviceName;

    /**
     * 商户服务项目简称
     */
    private String serviceAbbreviation;

    /**
     * 服务项目状态
     */
    private String serviceStatus;

    /**
     * 服务归属 : storeService 中
     */
    private String serviceBelong;

    /**
     * 发放主体产品状态：主体项目状态
     */
    private String issuingBodyGoodsStatus;

    /**
     * 业务类型：主体中业务类型
     *
     * 主体 如果 该业务类型仅可发放已添加的专用产品：Y 再传递这个值
     */
    private String businessTypeCode;

    /**
     * 是否不分页查询
     */
    private Boolean notPage = Boolean.FALSE;

    /**
     * 第几页
     */
    private int page=1;

    /**
     * 没有大小
     */
    private int limit=10;


}
