package com.rocogz.merchant.entity.customer.workflow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

/**
 * 审批节点基类
 * @author zhangmin
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class BaseConfigNode extends IdEntity {

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 审批节点名称
     */
    private String nodeName;

    /**
     * 节点业务类型：审核或审批
     */
    private CustomerGoodsConfigNodeTypeEnum nodeType;

    /**
     * 审批节点顺序
     */
    private Integer seq;


    public String getNodeTypeLabel() {
        return this.getNodeType().getLabel();
    }

}
