package com.rocogz.merchant.entity.product;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户中心-客户下的产品分类 表
 * </p>
 *
 * @author zhangmin
 * @since 2023-08-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_product_catalog")
public class MerchantProductCatalog extends IdEntity {

    private static final long serialVersionUID = 1L;


    public static final String ROOT_PARENT_CODE = "0";

    public static final String CODE_SPLITER = "-";


    /**
     * 父级产品分类编码,父级产品分类编码为0的为一级产品分类
     */
    private String parentCode;


    /**
     * 分类目录url,例如：CPFL1000-CPFL1002-CPFL1004
     */
    private String codeUrl;

    /**
     * 产品分类编码,例如：CPFL1000
     */
    private String code;

    /**
     * 产品分类名称
     */
    private String name;

    /**
     * 合作客户编号
     *
     * @see MerchantCooperationCustomer#code
     */
    private String customerCode;

    /**
     * 启用状态,启用/停
     *
     * @see Constant.DictData#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 排序号
     */
    private Integer sortNum;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;


    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    @TableField(exist = false)
    private String parentName;


    public boolean hasParent() {
        return StringUtils.isNotBlank(parentCode) && !ROOT_PARENT_CODE.equals(parentCode);
    }

}
