package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:库存的调拨提交请求</dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockAllocateSubmitReq {


    /**
     * 调拨申请单号
     */
    @NotBlank(message = "调拨申请单号")
    private String code;
    /**
     * 操作人
     */
    @NotBlank(message = "请传递操作人")
    private String operator;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
