package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 套餐商品
 * </p>
 *
 * @author yinshihao
 * @since 2021-01-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantGoodsMeal extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 平台商品编码
     */
    private String goodsCode;

    /**
     * 套餐明细平台商品编码
     */
    private String mealGoodsCode;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    private Integer sum;

    /**
     * 商品名称
     */
    @TableField(exist = false)
    private String name;

    /**
     * 产品类型名称
     */
    @TableField(exist = false)
    private String goodsTypeName;

    /**
     * 产品分类名称
     */
    @TableField(exist = false)
    private String goodsClassificationName;

    /**
     * 状态
     */
    @TableField(exist = false)
    private String status;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    @TableField(exist = false)
    private String supplierGoodsName;

    /**
     * 图片
     */
    @TableField(exist = false)
    private String listView;

    /**
     * 卡券左上角标签
     */
    @TableField(exist = false)
    private String cardCouponLeftCornerLabel;

    /**
     * 卡券金额下方注释内容
     */
    @TableField(exist = false)
    private String cardCouponNotes;

    /**
     * 使用说明
     */
    @TableField(exist = false)
    private String introduce;

    /**
     * 产品类别 特别容易搞不清楚 这是产品类别
     */
    @TableField(exist = false)
    private String goodsType;

    /**
     * 产品内容
     */
    @TableField(exist = false)
    private String goodsContent;

    
    /**
     * 商品平台产品的市场价
     */
    @TableField(exist = false)
    private BigDecimal merchantGoodsMarketPrice;
}
