package com.rocogz.merchant.client.scm.intfc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;

/**
 * @author yinshihao
 * @Description: 四川中石油发券请求参数
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2022-08-01 10:36:17
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class DingjuOilSczsyOrderReqDto extends BaseConfigReqDto {

    /**
     * 发券手机号
     */
    @NotEmpty(message = "发券手机号不可为空")
    @JsonProperty("mobile")
    private String mobile;

    /**
     * 商户订单号
     */
    @NotEmpty(message = "商户订单号不可为空")
    @JsonProperty("out_order_id")
    private String outOrderId;

    /**
     * 产品编号，测试产品编号qyface100
     */
    @NotEmpty(message = "商品编码不可为空,鼎聚那边给的第三方商品编号, qyface100")
    @JsonProperty("shortname")
    private String shortname;

    /**
     * 核销通知地址
     */
    @JsonProperty("use_notify_url")
    private String useNotifyUrl;
}
