package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 星星充电-奖品对象
 */
@Data
@Accessors(chain = true)
public class StarChargeAward {

    /**
     * 电子卡券类型
     * 1抵用卡
     * @see com.rocogz.merchant.constant.StarChargeConstant.STAR_CHARGE_AWARD_TYPE
     */
    @JsonProperty(value = "Type")
    private String Type;

    /**
     * 额度值
     */
    @JsonProperty(value = "Amount")
    private BigDecimal Amount;

    /**
     * 有效开始时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "StartTime")
    private LocalDateTime StartTime;

    /**
     * 有效结束时间
     * 格式yyyy-MM-dd  00:00:00
     */
    @JsonProperty(value = "EndTime")
    private LocalDateTime EndTime;

    /**
     * 发放数量
     */
    @JsonProperty(value = "Count")
    private String Count;

}
