package com.rocogz.merchant.constant;

/**
 * 星星充电的常量
 */
public interface StarChargeConstant {

    /**状态：成功*/
    int Succ_Stat_SUCCESS = 0;
    /**状态：失败*/
    int Succ_Stat_FAIL = 1;
    /**状态：token失败*/
    int Succ_Stat_TOKEN_FAIL = 4002;

    int RET_SUCCESS = 0;

    /**
     * 接口类型
     */
    interface INTERFACE_TYPE{

        /**接口类型-卡券发放*/
        int COUPON_PROVIDE = 0;

        /**接口类型-卡券禁用*/
        int COUPON_FORBIDDEN = 1;

        /**接口类型-卡券列表查询*/
        int QUERY_COUPON_INFO = 2;

    }

    /**
     * 星星充电-电子卡券类型
     */
    interface STAR_CHARGE_AWARD_TYPE{

        /**电子卡券类型-抵用卡*/
        String USE_CARD = "1";

    }

    /**
     * 星星充电-电子卡券类型
     * 状态：0:已创建，1:已激活 2:已用完 3:已作废 4:已冻结 5:已过期 6:已绑定未激活 7：已膨胀
     */
    interface STAR_CHARGE_COUPON_TYPE{

        /**已创建*/
        String CREATED = "0";

        /**已激活*/
        String SUCCESS = "1";

        /**已用完*/
        String USED = "2";

        /**已作废*/
        String FORBIDDEN = "3";

        /**已冻结*/
        String FREEZE = "4";

        /**已失效*/
        String INVALID = "5";

    }






}
