package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * <dl>
 * <dd>Description:更新 </dd>
 * <dd>@date: 2023/08/03</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyCustomerGoodsSortSaveReq {

    /**
     * 发放主体编号
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 创建人
     */
    @NotBlank
    private String createUser;

    /**
     * 更新提交的数据
     */
    @NotEmpty
    private List<IssuingBodyGoodsItem> goodsItems;


    /**
     * 业务类型：主体中业务类型
     *
     * 主体 如果 该业务类型仅可发放已添加的专用产品：Y 再传递这个值
     */
    private String businessTypeCode;


    @Data
    public static class IssuingBodyGoodsItem {

        private Integer issuingBodyGoodsId;

        private Integer sort;

    }
}
