package com.rocogz.merchant.dto.goods;

import com.rocogz.merchant.entity.product.MerchantProductCatalog;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 商户中心- 客户产品绑定分类Dto
 * </p>
 *
 * @author zhangmin
 * @since 2023-08-15
 */
@Data
@Accessors(chain = true)
public class MerchantCustomerProductBindCatalogDto {

    /**
     * 产品分类编号
     *
     * @see MerchantProductCatalog#code
     */
    private String catalogCode;

    /**
     * 合作客户产品编号列表
     */
    private List<String> customerProductCodeList;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
