package com.rocogz.merchant.dto.supplierGoods;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:权益产品库产品列表 </dd>
 * <dd>@date: 2023/07/21</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class SupplierEquityGoodsPagePageReq {

    /**
     * 申请单号
     */
    private String inStoreApplyCode;

    /**
     * 合作客户编号
     */
    private String customerCodeListStr;

    /**
     * 合作客户列表 产品库
     */
    private List<String> customerCodeList;

    /**
     * 合作客户产品编号
     */
    private String customerGoodsCode;

    /**
     * 产品简称
     */
    private String goodsAbbreviation;

    /**
     * ERP产品编号
     */
    private String erpGoodsCode;

    /**
     * 产品类型
     */
    private String goodsTypeCode;

    /**
     * 品牌
     */
    private String brandCodeListStr;

    /**
     * 产品品牌
     */
    private List<String> brandCodeList;

    /**
     * 平台产品
     */
    private String platformGoodsCode;

    /**
     * 客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 供应商管理
     */
    private List<String> supplierCodeList;

    /**
     * 供应商
     */
    private String supplierCodeListStr;

    /**
     * 排序属性 proWhBelongType,customer_goods_create_time_desc
     */
    private String sortProp;

    /**
     * 每页多少
     */
    private int limit=10;

    /**
     * 当前第几页
     */
    private int page=1;

}
