package com.rocogz.merchant.entity.channel.product;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 第三方平台实体类
 * @date：2021/11/23
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("merchant_third_platform")
public class MerchantThirdPlatform extends IdEntity {

    private static final long serialVersionUID = 619284948410245925L;

    /**
     * 上游通道，广东中石油，走此通道的油品牌包括：ZGSY(中石油), ZYBP(中油BP)
     */
    public static final String DJ_GDZSY = "DJ_GDZSY";

    /**
     * 上游通道，四川中石油
     */
    public static final String DJ_SCZSY = "DJ_SCZSY";

    //要走广东中石油 通道的，油品牌
    public static List<String> GDZSY_CHANNEL_BRANDS = new ArrayList<>();

    static {
        GDZSY_CHANNEL_BRANDS.add(MerchantBrand.ZGSY);
        GDZSY_CHANNEL_BRANDS.add(MerchantBrand.ZYBP);
    }


    /**
     * 平台编号(自定义、唯一)
     */
    @NotBlank(message = "平台编号不能为空")
    private String platformCode;

    /**
     * 平台名称
     */
    @NotBlank(message = "平台名称不能为空")
    private String platformName;

    /**
     * 平台状态
     */
    @NotBlank(message = "平台状态不能为空")
    private String status;

    /**
     * 平台描述
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 创建人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 编辑前的平台名称（编辑时使用到）
     */
    @TableField(exist = false)
    private String prePlatformName;
}