package com.rocogz.merchant.entity.customer.workflow.apply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <dl>
 * <dd>Description: 产品入库申请：工作流运行时节点（流程走完毕后，会删除运行时数据）</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 16:29</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("merchant_customer_goods_instore_apply_runtime_node")
public class GoodsInstoreApplyRuntimeNode extends IdEntity {

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 审批的节点名称
     */
    private String nodeName;

    /**
     * 审批节点类型：审核/审批/复核
     */
    private CustomerGoodsConfigNodeTypeEnum nodeType;

    /**
     * 该审批节点的顺序
     */
    private int seq;

    /**
     * 流程定义的版本
     */
    private int version;

    /**
     * 下一个审批节点
     */
    private String nextNodeCode;

    /**
     * 该节点是否审批完了，即是否走完了该流程，0表示未审批，1表示审批完毕
     */
    private boolean approved;

    /**
     * 节点审批人
     */
    @TableField(exist = false)
    private List<GoodsInstoreApplyRuntimeNodeApprover> runtimeApproverList;

    /**
     * 获取当前节点审批人列表（username集合）
     *
     * @return
     */
    @JsonIgnoreProperties
    public List<String> getApproverUsernameList() {
        if (CollectionUtils.isEmpty(runtimeApproverList)) {
            return Collections.emptyList();
        }

        return runtimeApproverList.stream().map(GoodsInstoreApplyRuntimeNodeApprover::getApproverUser)
                .distinct()
                .collect(Collectors.toList());
    }
}
