package com.rocogz.merchant.entity.product;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 合作商户产品所属分类标签， 多对多关系
 *
 * @author zhangmin
 * @since 2023-08-15
 */
@Accessors(chain = true)
@Data
@TableName("merchant_customer_goods_catalog")
public class MerchantCustomerGoodsCatalog extends IdEntity {

    /**
     * 合作客户产品编号
     */
    private String customerProductCode;

    /**
     * 分类编号
     *
     * @see MerchantProductCatalog#code
     */
    private String catalogCode;

    /**
     * 客户编号，方便前端数据查询
     */
    private String customerCode;

    /**
     * 所属分类url
     * @see MerchantProductCatalog#codeUrl
     */
    private String catalogCodeUrl;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
