package com.rocogz.merchant.entity.store;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户联系人
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreContacts extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 联系人
     */
    private String name;

    /**
     * 电话/手机
     */
    private String tel;

    /**
     * 职务
     */
    private String job;

    /**
     * 是否车主端显示：Y/N
     */
    private String ownerShow;


}
