package com.rocogz.merchant.entity.areaservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.service.ServiceClassification;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 专区服务主表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAreaService extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 专区服务项目编码
     */
    private String code;

    /**
     * 专区服务项目名称
     */
    private String name;

    /**
     * 专区服务项目简称
     */
    private String abbreviation;

    /**
     * 服务分类编码
     */
    private String cataCode;

    /**
     * 服务分类对象
     */
    @TableField(exist = false)
    private ServiceClassification cata;

    /**
     * 是否套餐 Y/N
     */
    private String combo;

    /**
     * 专区项目范围
     */
    private String nature;

    /**
     * 如果是部分专区的话，则为专区的数量
     */
    @TableField(exist = false)
    private Integer areas;

    /**
     * 专区服务项目介绍
     */
    private String introduce;

    /**
     * 列表图路径
     */
    private String listImage;

    /**
     * 详情图路径
     */
    private String detailImage;

    /**
     * 状态
     */
    private String status;

    /**
     * 专区服务项目对应的专区列表
     */
    @TableField(exist = false)
    private List<MerchantAreaServiceRelate> relates;

    /**
     * 专区服务项目评价维度列表
     */
    @TableField(exist = false)
    private List<MerchantAreaServiceEvaluativeDimension> dimensions;

    /**
     * 印象标签列表
     */
    @TableField(exist = false)
    private List<MerchantAreaServiceImpressionLabelRelate> impressionLabelRelates;
}
