package com.rocogz.syy.oilc.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.oilc.dto.dailyPrice.AddPriceConfigDto;
import com.rocogz.syy.oilc.dto.jms.PlutusRefundResultQueryMsg;
import com.rocogz.syy.oilc.dto.order.*;
import com.rocogz.syy.oilc.dto.plutuspay.PlutusNotify;
import com.rocogz.syy.oilc.entity.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The interface Oil c client service.
 */
public interface IOilCClientService {

    /**
     * 取消订单.
     *
     * @return the response
     */
    @PostMapping("/oilc/order/cancel")
    @ApiOperation(value = "取消订单")
    Response cancelOrder(@RequestBody CancelOderDto cancelOderDto);

    /**
     * Expire order response.
     *
     * @param scmOrderItemCode the scm order item code
     * @return response response
     */
    @GetMapping("/oilc/order/expire")
    Response expireOrder(@RequestParam("scmOrderItemCode") String scmOrderItemCode);

    /**
     * Expire order response.
     *
     * @return the response
     */
    @PostMapping("/oilc/order/expireOrderBatch")
    @ApiOperation("批量更新订单状态为已过期")
    Response expireOrderBatch(@RequestBody List<String> scmOrderItemCodeList);

    /**
     * Gets order.
     *
     * @param orderCode the order code
     * @return the order
     */
    @GetMapping("/oilc/order/{orderCode}")
    Response<OilcOrder> getOrder(@PathVariable(name = "orderCode") String orderCode);

    /**
     * Simple query response.
     *
     * @param orderCode    the order code
     * @param outOrderCode the out order code
     * @return the response
     */
    @GetMapping("/oilc/order/query")
    Response<OilcOrder> simpleQuery(@RequestParam(value = "orderCode", required = false) String orderCode,
                                    @RequestParam(value = "outOrderCode", required = false) String outOrderCode);

    /**
     * 调用分销下单结果更新.
     *
     * @param updateDto the update dto
     * @return the response
     */
    @PostMapping("/oilc/order/callScmResultUpdate")
    Response callScmResultUpdate(@RequestBody CallScmResultUpdateDto updateDto);

    /**
     * 订单充值成功的回调通知.
     *
     * @param notifyDto the notify dto
     * @return the response
     */
    @PostMapping("/oilc/order/rechargedSuccessNotify")
    @ApiOperation("订单充值成功的回调通知")
    Response rechargedSuccessNotify(@RequestBody RechargeSuccessNotifyDto notifyDto);

    /****************************************** 订单支付 yinshihao Start   ***********************************************/
    /**
     * 创建支付单.
     *
     * @param req the req
     * @return the response
     */
    @PostMapping("/oilc/orderPay/c/pay")
    Response<WxPayInfoDto> pay(@RequestBody WxPayReq req);

    /**
     * 支付成功回调接口.
     *
     * @param plutusNotify the plutus notify
     * @return the response
     */
    @PostMapping("/oilc/orderPay/paySuccess")
    Response<OilcOrder> paySuccess(@RequestBody PlutusNotify plutusNotify);

    /**
     * 订单支付列表查询接口
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/oilc/orderPay/orderPayPageQuery")
    PageTable<OilcOrderPay> orderPayPageQuery(@RequestBody OrderPayQueryDto queryDto);

    /**
     * 得到订单支付的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/oilc/orderPay/getOrderPayTotalCount")
    Response<Integer> getOrderPayTotalCount(@RequestBody OrderPayQueryDto queryDto);

    /****************************************** 订单支付 yinshihao Start   ***********************************************/
    /**
     * Create order response.
     *
     * @param createOrderDto the create order dto
     * @return the response
     */
    @PostMapping("/oilc/order/c/createOrder")
    Response<CreateOrderRespDto> createOrder(@RequestBody CreateOrderDto createOrderDto);

    /**
     * 获取所有失败订单列表
     * @return
     */
    @GetMapping("/oilc/order/findFailOrderList")
    Response<List<OilcOrder>> findFailOrderList();

    /**
     * 订单退款.
     *
     * @param orderRefundDto the order refund dto
     * @return the response
     */
    @PostMapping("/oilc/order/refund")
    Response refund(@RequestBody OrderRefundDto orderRefundDto);

    /**
     * 订单状态修改
     * @param statusChangeDto
     * @return
     */
    @PostMapping("/oilc/order/statusChange")
    @ApiOperation("订单状态修改")
    Response statusChange(@Validated @RequestBody OrderStatusChangeDto statusChangeDto);

    /**
     * 获取每日油价信息
     * @return
     */
    @GetMapping("/oilc/oilPriceDaily/c/list")
    Response<List<OilcOilPriceDaily>> listOilPrice();

    @PostMapping("/oilc/orderRefund/updateRefundResult")
    Response updateRefundResult(@RequestBody PlutusRefundResultQueryMsg resultQueryMsg);

    /**
     * 订单使用回调
     * @param orderUsedNotifyDto
     * @return
     */
    @PostMapping("/oilc/order/usedNotify")
    Response usedNotify(@RequestBody OrderUsedNotifyDto orderUsedNotifyDto);

    /**
     * 订单列表查询接口
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/oilc/order/orderPageQuery")
    PageTable<OrderPageRespDto> orderPageQuery(@RequestBody OrderQueryDto queryDto);

    /**
     * 得到订单的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/oilc/order/getOrderTotalCount")
    Response<Integer> getOrderTotalCount(@RequestBody OrderQueryDto queryDto);

    /****************************************** 订单退款 yinshihao Start   ***********************************************/
    /**
     * 退款申请列表查询接口
     *
     * @param queryDto 查询参数Dto
     * @return
     */
    @PostMapping("/oilc/orderRefundApply/orderRefundApplyPageQuery")
    PageTable<RefundApplyPageRespDto> orderRefundApplyPageQuery(@RequestBody RefundApplyQueryDto queryDto);

    /**
     * 创建退款申请
     *
     * @param refundApply
     * @return
     */
    @PostMapping("/oilc/orderRefundApply/createRefundApply")
    Response<String> createRefundApply(@RequestBody OilcOrderRefundApply refundApply);

    /**
     * 审批
     *
     * @param refundApplyApproveReqDto
     * @return
     */
    @PostMapping("/oilc/orderRefundApply/approveRefundApply")
    Response<String> approveRefundApply(@RequestBody RefundApplyApproveReqDto refundApplyApproveReqDto);

    /**
     * 根据退款申请单号获取退款申请详情
     *
     * @param applyNo
     * @return
     */
    @GetMapping("/oilc/orderRefundApply/getRefundApplyByApplyNo")
    Response<OilcOrderRefundApply> getRefundApplyByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 根据申请单号修改申请单信息
     *
     * @param refundApply
     * @return
     */
    @PostMapping("/oilc/orderRefundApply/updateRefundApplyByApplyNo")
    Response<Boolean> updateRefundApplyByApplyNo(@RequestBody OilcOrderRefundApply refundApply);

    /**
     * 得到申请单的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/oilc/orderRefundApply/getRefundApplyTotalCount")
    Response<Integer> getRefundApplyTotalCount(@RequestBody RefundApplyQueryDto queryDto);

    /**
     * 根据订单编号获取申请单列表
     *
     * @param orderCode 订单编号
     * @return
     */
    @GetMapping("/oilc/orderRefundApply/getRefundApplyListByOrderCode")
    Response<List<OilcOrderRefundApply>> getRefundApplyListByOrderCode(@RequestParam("orderCode") String orderCode);
    /****************************************** 订单退款 yinshihao end  ************************************************/

    /**
     * 计算订单价格和加油升数
     *
     * @return response
     */
    @PostMapping("/oilc/product/calculateAmount")
    Response<CalculateAmountResp> calculateAmount(@RequestBody CalculateAmountReq req);

    /**
     * 批量计算订单价格和加油升数
     *
     * @return response
     */
    @PostMapping("/oilc/product/calculateAmountBatch")
    Response<List<CalculateAmountBatchResp>> calculateAmountBatch(@RequestBody CalculateAmountBatchReq req);

    /****************************************** C端加油后台 huangdeyi Start   ***********************************************/

    /**
     * 按条件分页查询渠道信息
     * @param name
     * @param status
     * @param issuingBodyCode
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/oilc/channel/list")
    PageTable<OilcChannel> selectOilcChannelList(@RequestParam(name = "name", required = false) String name,
                                                 @RequestParam(name = "status", required = false) String status,
                                                 @RequestParam(name = "issuingBodyCode", required = false) String issuingBodyCode,
                                                 @RequestParam(name = "page", required = false) int page,
                                                 @RequestParam(name = "limit", required = false) int limit);

    /**
     * 更加codes查询对应的渠道信息，codes以","分隔
     * @param codes
     * @return
     */
    @GetMapping("/oilc/channel/listByCodes")
    Response<List<OilcChannel>> selectOilcChannelListByCodes(@RequestParam(name = "codes", required = true) String codes);

    /**
     * 新增或编辑渠道信息
     * @param channel
     * @return
     */
    @PostMapping("/oilc/channel/addOrUpdate")
    Response addOrUpdateOilcChannel(@RequestBody OilcChannel channel);

    /**
     * 管理后台获取所有油价信息
     * @return
     */
    @GetMapping("/oilc/oilPriceDaily/list")
    Response<List<OilcOilPriceDaily>> selectPriceDailyList();

    /**
     * 根据标号获取对应的每日油价配置记录
     * @param oilQuality
     * @return
     */
    @GetMapping("/oilc/oilPriceDaily/config/list/{oilQuality}")
    Response<List<OilcOilPriceConfig>> selectOilPriceDailyConfigList(@PathVariable(name = "oilQuality") String oilQuality);

    /**
     * 新增油价配置
     * @param configDto
     * @return
     */
    @PostMapping("/oilc/oilPriceDaily/add/config")
    Response addOilPriceDailyConfig(@RequestBody AddPriceConfigDto configDto);

    /**
     * 根据油价配置id删除配置信息
     * @param id
     * @return
     */
    @PostMapping("/oilc/oilPriceDaily/del/config/{id}")
    Response deletePriceDailyConfigById(@PathVariable("id") Integer id);

    /**
     * 根据条件分页查询C端加油产品
     * @param code
     * @param name
     * @param customerProductCode
     * @param customerProductName
     * @param status
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/oilc/product/list")
    PageTable<OilcProduct> selectOilcProductList(@RequestParam(name = "code", required = false) String code,
                                                 @RequestParam(name = "name", required = false) String name,
                                                 @RequestParam(name = "customerProductCode", required = false) String customerProductCode,
                                                 @RequestParam(name = "customerProductName", required = false) String customerProductName,
                                                 @RequestParam(name = "status", required = false) String status,
                                                 @RequestParam(name = "page", required = false, defaultValue = "1") int page,
                                                 @RequestParam(name = "limit", required = false, defaultValue = "10") int limit);

    /**
     * 根据codes查询对应的C端产品信息，codes以","分隔
     * @param codes
     * @return
     */
    @GetMapping("/oilc/product/listByCodes")
    Response<List<OilcProduct>> selectOilcProductListByCodes(@RequestParam(name = "codes", required = true) String codes);

    /**
     * 新增或更新C端加油产品
     * @param product
     * @return
     */
    @PostMapping("/oilc/product/addOrUpdate")
    Response addOrUpdateOilcProduct(@RequestBody OilcProduct product);

    /**
     * 根据编号删除C端加油产品
     * @param code
     * @return
     */
    @PostMapping("/oilc/product/del/{code}")
    Response deleteOilcProductByCode(@PathVariable("code") String code);

    /****************************************** C端加油后台 huangdeyi End   ***********************************************/

    /**
     * 根据各个标号油价获取对应的每日油价配置记录
     * @return
     */
    @GetMapping("/oilc/oilPriceConfig/listOilPriceConfigQualityNewOne")
    Response<List<OilcOilPriceConfig>> listOilPriceConfigQualityNewOne();
    /**
     * 定时任务更新每日油价信息
     * @return
     */
    @PostMapping("/oilc/oilPriceDaily/scheduleUpdate")
    Response scheduleUpdatePriceDaily();
}
