package com.rocogz.syy.oilc.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class OilCConstant {
    private OilCConstant(){}

    public static final String APPLICATION_NAME = "oil-c-service";

    public static final String ORDER_OPERATE_USER_SCM = "SCM";

    /**
     * 通用启用、停用
     */
    public static final String COMMON_STATUS_OPEN = "OPEN";
    public static final String COMMON_STATUS_LOCK = "LOCK";

    /**
     * 超时订单取消类型：用户主动取消、系统自动取消
     */
    public static final String TIMEOUT_ORDER_CANCEL_TYPE_USER = "USER_CANCEL";
    public static final String TIMEOUT_ORDER_CANCEL_TYPE_SYSTEM = "SYSTEM_CANCEL";

    /**
     * 活动状态
     */
    public static class ActivityStatus {
        public static final String TYPE_CODE = "OILC_ACTIVITY_STATUS";
        public static final String DRAFT = "DRAFT";
        public static final String STAYINGON = "STAYINGON";
        public static final String UP_LIST = "UP_LIST";
        public static final String DOWN_LIST = "DOWN_LIST";
        public static final String INVALID = "INVALID";
    }

    /**
     * 支付状态
     */
    public static class OrderPayStatus {
        public static final String TYPE_CODE = "OILC_ORDER_PAY_STATUS";
        /**
         * 未支付
         */
        public static final String PENDING_PAY = "PENDING_PAY";
        /**
         * 已支付
         */
        public static final String PAID = "PAID";
        /**
         * 待退款
         */
        public static final String PENDING_REFUND = "PENDING_REFUND";
        /**
         * 退款中
         */
        public static final String REFUNDING = "REFUNDING";
        /**
         * 退款成功
         */
        public static final String REFUND_SUCCESS = "REFUND_SUCCESS";
        /**
         * 退款失败
         */
        public static final String REFUND_FAIL = "REFUND_FAIL";
    }

    /**
     * 订单状态
     */
    public static class OrderStatus {
        public static final String TYPE_CODE = "OILC_ORDER_STATUS";
        /**
         * 待支付
         */
        public static final String PENDING_PAY = "PENDING_PAY";
        /**
         * 待充值
         */
        public static final String PENDING_RECHARGE = "PENDING_RECHARGE";
        /**
         * 充值中
         */
        public static final String RECHARGING = "RECHARGING";
        /**
         * 充值失败
         */
        public static final String RECHARGE_FAIL = "RECHARGE_FAIL";
        /**
         * 已充值
         */
        public static final String RECHARGE_SUCCESS = "RECHARGE_SUCCESS";
        /**
         * 已取消
         */
        public static final String CANCEL = "CANCEL";
        /**
         * 已过期
         */
        public static final String EXPIRED = "EXPIRED";
        /**
         * 撤回中
         */
        public static final String IN_RECALL = "IN_RECALL";
        /**
         * 已撤回
         */
        public static final String RECALL = "RECALL";
        /**
         * 已使用
         */
        public static final String USED = "USED";
    }


    /**
     * 退款申请状态
     */
    public static class RefundApplyStatus {
        public static final String TYPE_CODE = "REFUND_APPLY_STATUS";
        /**
         * 退款申请状态 待审批
         */
        public final static String REFUND_APPLY_STATUS_PENDING = "PENDING";

        /**
         * 退款申请状态 审批不通过
         */
        public final static String REFUND_APPLY_STATUS_REFUSE = "REFUSE";

        /**
         * 退款申请状态 审批通过
         */
        public final static String REFUND_APPLY_STATUS_PASS = "PASS";

        /**
         * 退款申请状态 退款中
         */
        public final static String REFUND_APPLY_STATUS_REFUSEING = "REFUSEING";

        /**
         * 退款申请状态 退款失败
         */
        public final static String REFUND_APPLY_STATUS_REFUND_FAIL = "REFUND_FAIL";

        /**
         * 退款申请状态 退款成功
         */
        public final static String REFUND_APPLY_STATUS_REFUND_SUCCESS = "REFUND_SUCCESS";
    }

    /**
     * 产品状态
     */
    public static class ProductStatus {

        /**
         * 产品状态字典type
         */
        public static final String PRODUCT_STATUS_TYPE = "OILC_PRODUCT_STATUS_TYPE";

        /**
         * 上架
         */
        public static final String PRODUCT_STATUS_UP_LIST = "UP_LIST";

        /**
         * 下架
         */
        public static final String PRODUCT_STATUS_DOWN_LIST = "DOWN_LIST";
    }

    /**
     * 每日油价配置生效状态
     */
    public static class PriceConfigStatus {

        /**
         * 已生效
         */
        public static final String PRICE_CONFIG_STATUS_EFFECTIVE = "已生效";

        /**
         * 待生效
         */
        public static final String PRICE_CONFIG_STATUS_TO_BE_EFFECTIVE = "待生效";
    }

    /**
     * 活动订单支付记录
     */
    public static class OrderPay {

        /**
         * 交易状态
         */
        public static final String ORDER_PAY_TRADE_STATUS = "ORDER_TRADE_STATUS";

        /**
         * 支付类型
         */
        public static final String ORDER_PAY_PAY_TYPE = "ORDER_PAY_TYPE";

        /**
         * 交易类型
         */
        public static final String ORDER_PAY_TRADE_TYPE = "ORDER_TRADE_TYPE";
    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /**
         * 商户编码序列编号
         */
        public final static String ORDER_REFUND_APPLY_CODE = "ORDER_REFUND_APPLY_CODE";

        /**
         * C端加油渠道编号
         */
        public final static String OILC_CHANNEL_CODE = "OILC_CHANNEL_CODE";

        /**
         * C端加油产品编号
         */
        public final static String OILC_PRODUCT_CODE = "OILC_PRODUCT_CODE";
    }
}
