package com.rocogz.syy.oilc.dto.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/8 16:58</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("创建订单参数DTO")
public class CreateOrderDto {
    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @NotEmpty(message = "渠道编码不可为空")
    private String channelCode;

    /**
     * 油站 Id
     */
    @ApiModelProperty("油站 Id")
    private String gasId;

    /**
     * 用户唯一标识
     */
    @ApiModelProperty("用户唯一标识")
    @NotEmpty(message = "用户唯一标识不可为空")
    private String userId;

    /**
     * 外部订单编号
     */
    @ApiModelProperty("外部订单编号")
    @NotEmpty(message = "外部订单编号不可为空")
    private String outOrderCode;

    /**
     * 油卡充值金额
     */
    @ApiModelProperty("油卡充值金额")
    @NotNull(message = "油卡充值金额")
    private BigDecimal rechargeAmount;

    /**
     * 油卡充值手机号
     */
    @ApiModelProperty("油卡充值手机号")
    @NotEmpty(message = "油卡充值手机号不可为空")
    private String rechargeMobile;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 渠道优惠券编码
     */
    @ApiModelProperty("渠道优惠券编码")
    private String channelDiscountCouponCode;

    /**
     * 渠道优惠金额
     */
    @ApiModelProperty("渠道优惠金额")
    private BigDecimal channelDiscountAmount;
}
