package com.rocogz.syy.oilc.dto.plutuspay;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022/4/25 14:24</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class PlutusTradeDetail {
    /**
     * 交易流水号
     */
    String tradeId;
    /**
     * 第三方交易流水号，不长于30位，第三方全局唯一
     */
    String outTransId;
    /**
     * 支交易类型，1消费、2撤销、3退货、4预授权、5预授权完成、6预授权撤销、7预授权完成撤销
     */
    Integer tradeTypeId;
    /**
     * 交易金额，单位：元
     */
    BigDecimal tradeAmount;
    /**
     * 银行优惠金额，单位：元
     */
    BigDecimal bankOffsetAmount;
    /**
     * 实收金额，单位：元
     */
    BigDecimal receiveAmount;
    /**
     * 交易时间
     */
    LocalDateTime tradeTime;
    /**
     * 交易状态，1开始交易、2交易成功、3交易失败、5未确定
     */
    Integer tradeStatus;
    /**
     * 会员卡号
     */
    String merberCard;
    /**
     * 交易结果
     */
    String payResult;
    /**
     * 支付类型，0默认、1001现金、1003微信、1004支付宝、1006银行卡、1010银联扫码、1012翼支付、1014龙支付、1015分期支付
     */
    Integer payTypeId;
    /**
     * 支付卡号
     */
    String payAccount;
    /**
     * 渠道商户编号
     */
    String merchantCode;
    /**
     * 渠道终端编号
     */
    String terminalCode;
    /**
     * 设备号、虚拟设备号
     */
    String sn;
    /**
     * 手续费
     */
    BigDecimal fee;
    /**
     * 第三方收银号
     */
    String caseierPayNO;
}
