package com.rocogz.syy.oilc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("oilc_order")
public class OilcOrder extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String orderCode;

    /**
     * 外部订单编号
     */
    @ApiModelProperty("外部订单编号")
    private String outOrderCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 发放主体编码
     */
    @ApiModelProperty("发放主体编码")
    private String issuingBodyCode;

    /**
     * 外部用户标识
     */
    @ApiModelProperty("外部用户标识")
    private String userId;

    /**
     * 油站 Id
     */
    @ApiModelProperty("油站 Id")
    private String gasId;

    /**
     * 产品编号
     */
    @ApiModelProperty("产品编号")
    private String productCode;

    /**
     * 合作客户产品编码
     */
    @ApiModelProperty("合作客户产品编码")
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    @ApiModelProperty("合作客户产品名称")
    private String customerProductName;

    /**
     * 油卡充值手机号
     */
    @ApiModelProperty("油卡充值手机号")
    private String rechargeMobile;

    /**
     * 油卡充值金额
     */
    @ApiModelProperty("油卡充值金额")
    private BigDecimal rechargeAmount;

    /**
     * 订单总金额
     */
    @ApiModelProperty("订单总金额")
    private BigDecimal totalAmount;

    /**
     * 订单优惠金额
     */
    @ApiModelProperty("订单优惠金额")
    private BigDecimal discountAmount;

    /**
     * 渠道优惠券编码
     */
    @ApiModelProperty("渠道优惠券编码")
    private String channelDiscountCouponCode;

    /**
     * 渠道优惠金额
     */
    @ApiModelProperty("渠道优惠金额")
    private BigDecimal channelDiscountAmount;

    /**
     * 需要支付的总金额
     */
    @ApiModelProperty("需要支付的总金额")
    private BigDecimal needPayTotalAmount;

    /**
     * 已支付总金额
     */
    @ApiModelProperty("已支付总金额")
    private BigDecimal payedTotalAmount;

    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;

    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;

    /**
     * 充值完成时间
     */
    @ApiModelProperty("充值完成时间")
    private LocalDateTime rechargeFinishTime;

    /**
     * 使用时间
     */
    @ApiModelProperty("使用时间")
    private LocalDateTime useTime;

    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    private LocalDateTime cancelTime;

    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDate expireDate;

    /**
     * 调用分销下单是否成功
     */
    private Boolean callScmSuccess;

    /**
     * 调用分销次数
     */
    private Integer callScmCnt;

    /**
     * 最后一次调用分销下单时间
     */
    @ApiModelProperty("最后一次调用分销下单时间")
    private LocalDateTime lastTimeCallScm;

    /**
     * 调用分销下单返回的数据
     */
    private String callScmRes;

    /**
     * 分销订单编号
     */
    @ApiModelProperty("分销订单编号")
    private String scmOrderCode;

    /**
     * 分销明细订单编号
     */
    @ApiModelProperty("分销明细订单编号")
    private String scmOrderItemCode;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 是否被逻辑删除
     */
    private boolean deleted;

    /**
     * 有效期开始日期
     */
    private LocalDateTime validityPeriodStartTime;

    /**
     * 有效期结束日期
     */
    private LocalDateTime validityPeriodEndTime;
}
