package com.rocogz.syy.oilc.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class OilCConstant {
    private OilCConstant(){}

    public static final String APPLICATION_NAME = "oil-c-service";

    public static final String ORDER_OPERATE_USER_SCM = "SCM";

    /**平台编码-壳牌*/
    public static final String USER_COUPON_PLATFORM_CODE_OIL_C = "OILC";

    /**品牌编码-壳牌*/
    public static final String OILC_ORDER_BAND_CODE_SHEL = "SHEL";

    /**
     * 核销中，这个状态不会保存到订单表里面，只是给前端传值查询，用于查出RECHARGE_SUCCESS、RECHARGE_FAIL、RECHARGING、PENDING_RECHARGE 四种状态
     */
    public static final String PENDING_WRITEOFF = "PENDING_WRITEOFF";

    /**
     * 已取消，这个状态不会保存到订单表里面，只是给前端传值查询，用于查出CANCEL、RECALL 两种状态
     */
    public static final String ORDER_CANCEL = "ORDER_CANCEL";

    /**
     * 通用启用、停用
     */
    public static final String COMMON_STATUS_OPEN = "OPEN";
    public static final String COMMON_STATUS_LOCK = "LOCK";

    /**
     * 超时订单取消类型：用户主动取消、系统自动取消
     */
    public static final String TIMEOUT_ORDER_CANCEL_TYPE_USER = "USER_CANCEL";
    public static final String TIMEOUT_ORDER_CANCEL_TYPE_SYSTEM = "SYSTEM_CANCEL";

    /**
     * 活动状态
     */
    public static class ActivityStatus {
        public static final String TYPE_CODE = "OILC_ACTIVITY_STATUS";
        public static final String DRAFT = "DRAFT";
        public static final String STAYINGON = "STAYINGON";
        public static final String UP_LIST = "UP_LIST";
        public static final String DOWN_LIST = "DOWN_LIST";
        public static final String INVALID = "INVALID";
    }

    /**
     * 现金支付状态
     */
    public static class OrderPayStatus {
        public static final String TYPE_CODE = "OILC_ORDER_PAY_STATUS";
        /**
         * 未支付
         */
        public static final String PENDING_PAY = "PENDING_PAY";
        /**
         * 已支付
         */
        public static final String PAID = "PAID";
        /**
         * 待退款
         */
        public static final String PENDING_REFUND = "PENDING_REFUND";
        /**
         * 退款中
         */
        public static final String REFUNDING = "REFUNDING";
        /**
         * 退款成功
         */
        public static final String REFUND_SUCCESS = "REFUND_SUCCESS";
        /**
         * 退款失败
         */
        public static final String REFUND_FAIL = "REFUND_FAIL";
    }

    /**
     * 订单状态
     */
    public static class OrderStatus {
        public static final String TYPE_CODE = "OILC_ORDER_STATUS";
        /**
         * 待支付 刚才创建的订单时，状态是待支付
         * @see com.rocogz.syy.oilc.service.IOilcOrderService#createOrder(com.rocogz.syy.oilc.dto.order.CreateOrderDto)
         */
        public static final String PENDING_PAY = "PENDING_PAY";

        /**
         * 待充值：微信支付成功回调后 或 抵扣券全部抵扣成功,状态变成待充值
         * @see com.rocogz.syy.oilc.controller.OilcOrderPayController#paySuccess(com.rocogz.syy.oilc.dto.plutuspay.PlutusNotify)
         */
        public static final String PENDING_RECHARGE = "PENDING_RECHARGE";

        /**
         * 充值中,如果分销下单成功则变成充值中
         * @see com.rocogz.syy.oilc.controller.OilcOrderController#callScmResultUpdate(com.rocogz.syy.oilc.dto.order.CallScmResultUpdateDto)
         * 上述接口已废弃，新版改为调分销后修改订单状态为RECHARGING
         * @see com.rocogz.syy.oilc.service.impl.OilcOrderServiceImpl#createScmOrderOnPayedSuccess(com.rocogz.syy.oilc.entity.OilcOrder)
         */
        public static final String RECHARGING = "RECHARGING";
        /**
         * 充值失败，分销上游订单下单失败，则更新为充值失败
         */
        public static final String RECHARGE_FAIL = "RECHARGE_FAIL";

        /**
         * 已充值,上游订单到鼎聚下单成功，就算已充值，即：上游订单状态=SUCCESS,则更新为已充值
         * @see com.rocogz.syy.oilc.controller.OilcOrderController#rechargedSuccessNotify(com.rocogz.syy.oilc.dto.order.RechargeSuccessNotifyDto)
         */
        public static final String
                RECHARGE_SUCCESS = "RECHARGE_SUCCESS";

        /**
         * 已取消，只有待支付的可以取消
         * 取消入口
         * @see com.rocogz.syy.oilc.service.impl.OilcOrderServiceImpl#cancelOrder(com.rocogz.syy.oilc.dto.order.CancelOderDto)
         */
        public static final String CANCEL = "CANCEL";

        /**
         * 已过期 使用有效期已过期后，更新为已过期
         * 壳牌的不会更新过期状态
         * @see com.rocogz.syy.oilc.controller.OilcOrderController#expireOrderBatch(java.util.List)
         */
        public static final String EXPIRED = "EXPIRED";
        /**
         * 撤回中
         */
        public static final String IN_RECALL = "IN_RECALL";
        /**
         * 已撤回,admin端撤回操作后,状态直接更新为已撤回
         * @see com.rocogz.syy.oilc.controller.OilcOrderController#statusChange(com.rocogz.syy.oilc.dto.order.OrderStatusChangeDto)
         */
        public static final String RECALL = "RECALL";
        /**
         * 已使用
         */
        public static final String USED = "USED";
    }


    /**
     * 订单第三方API调用状态
     */
    public static class OrderCallApiStatus {
        public static final String TYPE_CODE = "OILC_ORDER_CALL_API_STATUS";

        /**
         * 调起第三方状态
         */
        public final static String PENDING = "PENDING";

        /**
         * 成功
         */
        public final static String SUCCESS = "SUCCESS";

        /**
         * 失败
         */
        public final static String FAIL = "FAIL";
    }


    /**
     * 退款申请状态
     */
    public static class RefundApplyStatus {
        public static final String TYPE_CODE = "REFUND_APPLY_STATUS";
        /**
         * 退款申请状态 待审批
         */
        public final static String REFUND_APPLY_STATUS_PENDING = "PENDING";

        /**
         * 退款申请状态 审批不通过
         */
        public final static String REFUND_APPLY_STATUS_REFUSE = "REFUSE";

        /**
         * 退款申请状态 审批通过
         */
        public final static String REFUND_APPLY_STATUS_PASS = "PASS";

        /**
         * 退款申请状态 退款中
         */
        public final static String REFUND_APPLY_STATUS_REFUSEING = "REFUSEING";

        /**
         * 退款申请状态 退款失败
         */
        public final static String REFUND_APPLY_STATUS_REFUND_FAIL = "REFUND_FAIL";

        /**
         * 退款申请状态 退款成功
         */
        public final static String REFUND_APPLY_STATUS_REFUND_SUCCESS = "REFUND_SUCCESS";
    }

    /**
     * 产品状态
     */
    public static class ProductStatus {

        /**
         * 产品状态字典type
         */
        public static final String PRODUCT_STATUS_TYPE = "OILC_PRODUCT_STATUS_TYPE";

        /**
         * 上架
         */
        public static final String PRODUCT_STATUS_UP_LIST = "UP_LIST";

        /**
         * 下架
         */
        public static final String PRODUCT_STATUS_DOWN_LIST = "DOWN_LIST";
    }

    /**
     * 每日油价配置生效状态
     */
    public static class PriceConfigStatus {

        /**
         * 已生效
         */
        public static final String PRICE_CONFIG_STATUS_EFFECTIVE = "已生效";

        /**
         * 待生效
         */
        public static final String PRICE_CONFIG_STATUS_TO_BE_EFFECTIVE = "待生效";
    }

    /**
     * 活动订单支付记录
     */
    public static class OrderPay {

        /**
         * 交易状态
         */
        public static final String ORDER_PAY_TRADE_STATUS = "ORDER_TRADE_STATUS";

        /**
         * 支付类型
         */
        public static final String ORDER_PAY_PAY_TYPE = "ORDER_PAY_TYPE";

        /**
         * 交易类型
         */
        public static final String ORDER_PAY_TRADE_TYPE = "ORDER_TRADE_TYPE";
    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /**
         * 商户编码序列编号
         */
        public final static String ORDER_REFUND_APPLY_CODE = "ORDER_REFUND_APPLY_CODE";

        /**
         * C端加油渠道编号
         */
        public final static String OILC_CHANNEL_CODE = "OILC_CHANNEL_CODE";

        /**
         * C端加油产品编号
         */
        public final static String OILC_PRODUCT_CODE = "OILC_PRODUCT_CODE";
    }

    /**
     * 订单消费券状态
     */
    public static class OrderConsumeCouponStatus {
        public static final String TYPE_CODE = "OILC_CONSUME_COUPONS_STATUS";
        /**
         * 已使用
         * 创建完订单后优惠券的状态就是已使用
         * @see com.rocogz.syy.oilc.service.impl.OilcOrderServiceImpl#doCreateOrder
         */
        public static final String USED = "USED";
        /**
         * 已撤回
         * @see com.rocogz.syy.oilc.service.impl.OilcOrderServiceImpl#cancelOrder
         */
        public static final String REJECT = "REJECT";
    }


}
